<?php
/**
 * @author      Elicus <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2021 Elicus Technologies Private Limited
 * @version     2.2.6
 */
class El_Testimonial_Module extends ET_Builder_Module {
	public $slug       = 'el_md_testimonial_extended';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'https://diviextended.com/product/divi-testimonial-extended/',
		'author'     => 'Elicus',
		'author_uri' => 'https://elicus.com/',
	);

	public function init() {
		$this->name             = esc_html__( 'Testimonial Extended', 'divi-testimonial-extended' );
		$this->main_css_element = '%%order_class%%';
		add_filter( 'et_late_global_assets_list', array( $this, 'el_dte_late_assets' ), 10, 3 );
	}

	public function el_dte_late_assets( $assets_list, $assets_args, $et_dynamic_assets ) {
		if ( function_exists( 'et_get_dynamic_assets_path' ) && function_exists( 'et_is_cpt' ) ) {
			$cpt_suffix = et_is_cpt() ? '_cpt' : '';
			$assets_list['et_posts'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/posts{$cpt_suffix}.css",
			);
			$assets_list['et_icons_all'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/icons_all.css",
			);
			$assets_list['et_icons_fa'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/icons_fa_all.css",
			);
			$assets_list['et_icons_social'] = array(
				'css' => $assets_args['assets_prefix'] . "/css/icons_base_social.css",
			);
		}
		return $assets_list;
	}

	public function get_settings_modal_toggles() {
		return array(
			'general'  => array(
				'toggles' => array(
					'main_content'    => array(
						'title'    => esc_html__( 'Content', 'divi-testimonial-extended' ),
						'priority' => 1,
					),
					'slider_settings' => array(
						'title'    => esc_html__( 'Slider Settings', 'divi-testimonial-extended' ),
						'priority' => 2,
					),
					'layout_toggle'   => array(
						'title'    => esc_html__( 'Layout', 'divi-testimonial-extended' ),
						'priority' => 3,
					),
					'display_setting' => array(
						'title'    => esc_html__( 'Display Settings', 'divi-testimonial-extended' ),
						'priority' => 4,
					),
					'pagination_setting' => array(
						'title'    => esc_html__( 'Pagination Settings', 'divi-testimonial-extended' ),
						'priority' => 5,
					),
				),
			),
			'advanced' => array(
				'toggles' => array(
					'text' => array(
						'title' => esc_html__( 'Text', 'divi-testimonial-extended' ),
						'priority' => 1,
					),
					'title_text' => array(
						'title' => esc_html__( 'Title', 'divi-testimonial-extended' ),
						'priority' => 1,
					),
					'text_settings'        => array(
						'title'             => esc_html__( 'Testimonial Text Settings', 'divi-testimonial-extended' ),
						'sub_toggles'       => array(
							'body_text'        => array(
								'name' => 'Body',
							),
							'author_text'      => array(
								'name' => 'Author',
							),
							'author_meta_text' => array(
								'name' => 'Meta',
							),
						),
						'tabbed_subtoggles' => true,
					),
					'readmore_button' => array(
                        'title'     => esc_html__( 'Read More Button', 'divi-testimonial-extended' ),
                    ),
					'readless_link' => array(
                        'title'     => esc_html__( 'Read Less Button', 'divi-testimonial-extended' ),
                    ),
					'rating_settings'      => array(
						'title'    => esc_html__( 'Rating Settings', 'divi-testimonial-extended' ),
					),
					'quote_icon_settings'  => array(
						'title'             => esc_html__( 'Quote Icon Settings', 'divi-testimonial-extended' ),
						'tabbed_subtoggles' => true,
						'sub_toggles'       => array(
							'quote_icon_opening' => array(
								'name' => 'Opening Quote',
							),
							'quote_icon_closing' => array(
								'name' => 'Closing Quote',
							),
						),
					),
					'author_image_settings'       => array(
						'title'    => esc_html__( 'Author Image Settings', 'divi-testimonial-extended' ),
					),
					'pagination_settings' => array(
						'title'    => esc_html__( 'Pagination Settings', 'divi-testimonial-extended' ),
					),
					'slide_setting_toggle' => array(
						'title'    => esc_html__( 'Single Testimonial Settings', 'divi-testimonial-extended' ),
					),
					'slider_control'       => array(
						'title'    => esc_html__( 'Slider Control', 'divi-testimonial-extended' ),
					),
				),
			),
		);
	}

	public function get_advanced_fields_config() {
		return array(
			'fonts' => array(
				'title' => array(
					'label'     => esc_html__( 'Title', 'divi-testimonial-extended' ),
					'font_size' => array(
						'default'        => '20px',
						'range_settings' => array(
							'min'  => '8',
							'max'  => '150',
							'step' => '1',
						),
					),
					'text_orientation' => array(
						'default' => 'center',
					),
					'line_height' => array(
						'default'        => '1.7',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'letter_spacing' => array(
						'default'        => '0',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'header_level' => array(
						'default'  => 'h2',
					),
					'css'              => array(
						'main' => "{$this->main_css_element} .el-testimonial-title"
					),
					'hide_text_align'  => true,
					'toggle_slug'      => 'title_text',
				),
				'body' => array(
					'label'            => esc_html__( 'Body', 'divi-testimonial-extended' ),
					'css'              => array(
						'main'        => "{$this->main_css_element} .el-testimonial-desc, {$this->main_css_element} .el-testimonial-desc p",
						'color'       => "{$this->main_css_element} .el-testimonial-desc, {$this->main_css_element} .el-testimonial-desc p",
						'line_height' => "{$this->main_css_element} .el-testimonial-desc, {$this->main_css_element} .el-testimonial-desc p",
						'plugin_main' => "{$this->main_css_element} .el-testimonial-desc, {$this->main_css_element} .el-testimonial-desc p",
						'text_shadow' => "{$this->main_css_element} .el-testimonial-desc, {$this->main_css_element} .el-testimonial-desc p",
					),
					'font_size'        => array(
						'default'        => '16px',
						'range_settings' => array(
							'min'  => '8',
							'max'  => '100',
							'step' => '1',
						),
					),
					'text_orientation' => array(
						'default' => 'center',
					),
					'line_height'      => array(
						'default'        => '1.7',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'letter_spacing'   => array(
						'default'        => '0',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'hide_text_align'  => true,
					'toggle_slug'      => 'text_settings',
					'sub_toggle'       => 'body_text',
				),
				'author' => array(
					'label'           => esc_html__( 'Author', 'divi-testimonial-extended' ),
					'css'             => array(
						'main'        => "{$this->main_css_element} .el-testimonial-name",
						'color'       => "{$this->main_css_element} .el-testimonial-name",
						'plugin_main' => "{$this->main_css_element} .el-testimonial-name",
						'important'   => 'all',
					),
					'font_size'       => array(
						'default'        => '18px',
						'range_settings' => array(
							'min'  => '8',
							'max'  => '100',
							'step' => '1',
						),
					),
					'line_height'     => array(
						'default'        => '1.5',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'letter_spacing'  => array(
						'default'        => '0',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'hide_text_align' => true,
					'toggle_slug'     => 'text_settings',
					'sub_toggle'      => 'author_text',
				),
				'author_meta' => array(
					'label'           => esc_html__( 'Author Meta', 'divi-testimonial-extended' ),
					'css'             => array(
						'main'        => "{$this->main_css_element} .el-testimonial-designation, {$this->main_css_element} .el-testimonial-company, {$this->main_css_element} .el-testimonial-company a",
						'color'       => "{$this->main_css_element} .el-testimonial-designation, {$this->main_css_element} .el-testimonial-company, {$this->main_css_element} .el-testimonial-company a",
						'plugin_main' => "{$this->main_css_element} .el-testimonial-designation, {$this->main_css_element} .el-testimonial-company, {$this->main_css_element} .el-testimonial-company a",
						'important'   => 'all',
					),
					'font_size'       => array(
						'default'        => '18px',
						'range_settings' => array(
							'min'  => '8',
							'max'  => '100',
							'step' => '1',
						),
					),
					'line_height'     => array(
						'default'        => '1.5',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'letter_spacing'  => array(
						'default'        => '0',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'hide_text_align' => true,
					'toggle_slug'     => 'text_settings',
					'sub_toggle'      => 'author_meta_text',
				),
				'readless_link' => array(
					'label'      => esc_html__( 'Read less link', 'divi-testimonial-extended' ),
					'css'        => array(
						'main' => "{$this->main_css_element} .el-testimonial-desc .el-testimonial-readless-btn",
					),
					'font_size'   => array(
						'default' => '16px',
						'range_settings' => array(
							'min'  => '8',
							'max'  => '100',
							'step' => '1',
						),
					),
					'line_height'  => array(
						'default'        => '1.5',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'letter_spacing'  => array(
						'default'        => '0',
						'range_settings' => array(
							'min'  => '0.1',
							'max'  => '10',
							'step' => '0.1',
						),
					),
					'hide_text_align' => true,
					'depends_on'      => array( 'readmore_trigger' ),
					'depends_show_if' => 'expand_content',
					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'readless_link',
				),
			),
			'background'     => array(
				'css' => array(
					'main' => $this->main_css_element,
				),
			),
			'button' => array(
				'readmore_button' => array(
					'label'            => esc_html__( 'Read More Button', 'divi-testimonial-extended' ),
					'css'              => array(
						'main'         => "%%order_class%% .el-testimonial-desc .et_pb_button",
						'background'   => "%%order_class%% .el-testimonial-desc .et_pb_button",
						'alignment'    => "%%order_class%% .el-testimonial-desc .et_pb_button_wrapper",
						'important'    => 'all',
					),
					'margin_padding' => array(
						'css' => array(
							'margin'    => "%%order_class%% .el-testimonial-desc .et_pb_button",
							'padding'   => "%%order_class%% .el-testimonial-desc .et_pb_button",
							'important' => 'all',
						),
					),
					'no_rel_attr'       => true,
					'box_shadow'        => false,
					'use_alignment' 	=> true,
					'depends_on'        => array( 'enable_readmore' ),
					'depends_show_if'   => 'on',
					'tab_slug'			=> 'advanced',
					'toggle_slug'		=> 'readmore_button',
				),
			),
			'testimonial_margin_padding' => array(
				'testimonial_desc' => array(
					'margin_padding' => array(
						'css' => array(
							'margin'    => "{$this->main_css_element} .el-testimonial-layout .el-testimonial-desc",
							'padding'   => "{$this->main_css_element} .el-testimonial-layout .el-testimonial-desc",
							'important' => 'all',
						),
					),
				),
				'author_name' => array(
					'margin_padding' => array(
						'css' => array(
							'padding'   => "{$this->main_css_element} .el-testimonial-layout .el-testimonial-name",
							'important' => 'all',
						),
					),
				),
				'slider_container' => array(
					'margin_padding' => array(
						'css' => array(
							'padding'   => "{$this->main_css_element} .el-testimonial-layout .swiper-container",
							'important' => 'all',
						),
					),
				),
			),
			'margin_padding' => array(
				'css' => array(
					'main'      => $this->main_css_element,
					'important' => 'all',
				),
			),
			'borders' => array(
				'default' => array(
					'css' => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .layout1 .el-single-testimonial-card, %%order_class%% .layout2 .el-single-testimonial-card, %%order_class%% .layout3 .el-single-testimonial-card, %%order_class%% .layout4 .el-single-testimonial-card .el-testimonial-content',
							'border_styles' => '%%order_class%% .layout1 .el-single-testimonial-card, %%order_class%% .layout2 .el-single-testimonial-card, %%order_class%% .layout3 .el-single-testimonial-card, %%order_class%% .layout4 .el-single-testimonial-card .el-testimonial-content',
						),
					),
				),
				'author_image_border' => array(
					'css'             => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .el-testimonial-portrait img',
							'border_styles' => '%%order_class%% .el-testimonial-portrait img',
							'important' => 'all',
						),
					),
					'depends_show_if' => 'image',
					'label_prefix'    => esc_html__( 'Author Image', 'divi-testimonial-extended' ),
					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'author_image_settings',
				),
				'single_slide_border' => array(
					'css'             => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .el-testimonial-layout:not(.layout6) .el-testimonial-content, %%order_class%% .layout6 .el-testimonial-content-wrapper, %%order_class%% .layout1 .el-single-testimonial-card',
							'border_styles' => '%%order_class%% .el-testimonial-layout:not(.layout6) .el-testimonial-content, %%order_class%% .layout6 .el-testimonial-content-wrapper, %%order_class%% .layout1 .el-single-testimonial-card',
							'important' => 'all',
						),
					),
					'depends_on'      => array( 'use_slider' ),
					'depends_show_if' => 'on',
					'label_prefix'    => esc_html__( 'Slide', 'divi-testimonial-extended' ),
					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'slide_setting_toggle',
				),
			),
			'box_shadow' => array(
				'testimonial_box' => array(
					'label'       => esc_html__( 'Testimonial Card Box Shadow', 'divi-testimonial-extended' ),
					'css'         => array(
						'main' => '%%order_class%% .el-testimonial-layout:not(.layout6) .el-testimonial-content, %%order_class%% .layout6 .el-testimonial-content-wrapper, %%order_class%% .layout1 .el-single-testimonial-card',
					),
					'tab_slug'    => 'advanced',
					'toggle_slug' => 'slide_setting_toggle',
				),
				'default' => array(
					'css' => array(
						'main' => '%%order_class%%',
					),
				),
			),
			'text' => array(
				'options'               => array(
					'text_orientation'  => array(
						'default_on_front' => 'center',
					),
				),
			),
			'filters'      => false,
			'link_options' => false,
		);
	}

	public function get_fields() {
		return array(
			'testimonial_number' => array(
				'label'            => esc_html__( 'Number of Testimonials', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'configuration',
				'default'          => 10,
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Here you can specify the total number of testimonials to display.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'testimonial_order' => array(
				'label'            => esc_html__( 'Order', 'divi-testimonial-extended' ),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'options'          => array(
					'DESC' => esc_html__( 'DESC', 'divi-testimonial-extended' ),
					'ASC'  => esc_html__( 'ASC', 'divi-testimonial-extended' ),
				),
				'default'          => 'DESC',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Here you can specify the sorting order for the testimonials.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'testimonial_order_by' => array(
				'label'            => esc_html__( 'Order by', 'divi-testimonial-extended' ),
				'type'             => 'select',
				'option_category'  => 'configuration',
				'options'          => array(
					'date'     	=> esc_html__( 'Date', 'divi-testimonial-extended' ),
					'modified'	=> esc_html__( 'Modified Date', 'divi-testimonial-extended' ),
					'title'    	=> esc_html__( 'Title', 'divi-testimonial-extended' ),
					'name'     	=> esc_html__( 'Slug', 'divi-testimonial-extended' ),
					'ID'       	=> esc_html__( 'ID', 'divi-testimonial-extended' ),
					'rand'     	=> esc_html__( 'Random', 'divi-testimonial-extended' ),
					'rating'    => esc_html__( 'Rating', 'divi-testimonial-extended' ),
					'none'     	=> esc_html__( 'None', 'divi-testimonial-extended' ),
				),
				'default'          => 'date',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Here you can specify the order in which the testimonials will be displayed.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'testimonial_offset' => array(
				'label'            => esc_html__( 'Post Offset Number', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'configuration',
				'default'          => 0,
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Choose how many testimonials you would like to skip. These testimonials will not be shown on the page.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'include_categories' => array(
				'label'            => esc_html__( 'Include Categories', 'divi-testimonial-extended' ),
				'type'             => 'categories',
				'renderer_options' => array(
					'use_terms' => true,
					'term_name' => 'testimonial_category',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Select Categories. If no category is selected, testimonials from all categories will be displayed.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'exclude_post_ids' => array(
				'label'            		=> esc_html__( 'Exclude Testimonial IDs', 'divi-testimonial-extended' ),
				'type'           		=> 'text',
				'option_category'  		=> 'basic_option',
				'tab_slug'         		=> 'general',
				'toggle_slug'      		=> 'main_content',
				'description'      		=> esc_html__( 'If you would like to exclude specific testimonials from the loop then enter their ids here comma separated', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'show_title' => array(
				'label'            => esc_html__( 'Display Title', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Enable this to display the title with the testimonial content.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'enable_readmore' => array(
				'label'            => esc_html__( 'Enable Read More Button', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Enable read more button, this will remove all the tags on content to trim it by content length.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'content_length' => array(
				'label'            => esc_html__( 'Content Length', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'basic_option',
				'tab_slug'     	   => 'general',
				'default'          => '0',
				'show_if'          => array(
					'enable_readmore' => 'on',
				),
				'toggle_slug'      => 'main_content',
				'description'  	   => esc_html__( 'Enter the content length, that limit to the testimonial content text. Zero to display the full content.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'readmore_text' => array(
				'label'            => esc_html__( 'Read More Button Text', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'basic_option',
				'tab_slug'     	   => 'general',
				'default'          => esc_html__( 'Read More', 'divi-testimonial-extended' ),
				'show_if'          => array(
					'enable_readmore' => 'on',
				),
				'toggle_slug'      => 'main_content',
				'description'  	   => esc_html__( 'Enter the read more button text.', 'divi-testimonial-extended' ),
			),
			'readmore_inline' => array(
				'label'            => esc_html__( 'Display Inline', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'          => array(
					'enable_readmore' => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Display read more button as inline.', 'divi-testimonial-extended' ),
			),
			'readmore_trigger' => array(
				'label'            => esc_html__( 'OnClick Trigger', 'divi-testimonial-extended' ),
				'type'             => 'select',
				'options'          => array(
					'single_page'    => esc_html__( 'Open Single Testimonial Page', 'divi-testimonial-extended' ),
					'expand_content' => esc_html__( 'Expand Content Inline', 'divi-testimonial-extended' ),
				),
				'default'          => 'single_page',
				'show_if'          => array(
					'enable_readmore' => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'main_content',
				'description'      => esc_html__( 'Select the triggle action on click of read more button.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'readless_text' => array(
				'label'            => esc_html__( 'Read Less Link Text', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'basic_option',
				'tab_slug'     	   => 'general',
				'default'          => esc_html__( 'Read less', 'divi-testimonial-extended' ),
				'show_if'          => array(
					'enable_readmore'  => 'on',
					'readmore_trigger' => 'expand_content'
				),
				'toggle_slug'      => 'main_content',
				'description'  	   => esc_html__( 'Enter the read less link text.', 'divi-testimonial-extended' ),
			),
			'testimonial_layout' => array(
				'label'            => esc_html__( 'Testimonials Layout', 'divi-testimonial-extended' ),
				'type'             => 'select',
				'option_category'  => 'layout',
				'options'          => array(
					'layout1' => esc_html__( 'Layout 1', 'divi-testimonial-extended' ),
					'layout2' => esc_html__( 'Layout 2', 'divi-testimonial-extended' ),
					'layout3' => esc_html__( 'Layout 3', 'divi-testimonial-extended' ),
					'layout4' => esc_html__( 'Layout 4', 'divi-testimonial-extended' ),
					'layout5' => esc_html__( 'Layout 5', 'divi-testimonial-extended' ),
					'layout6' => esc_html__( 'Layout 6', 'divi-testimonial-extended' ),
				),
				'default'          => 'layout1',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'layout_toggle',
				'description'      => esc_html__( 'Here you can select the layout for the testimonials.', 'divi-testimonial-extended' ),
			),
			'number_of_columns' => array(
				'label'             => esc_html__( 'Number Of Columns', 'divi-testimonial-extended' ),
				'type'              => 'select',
				'option_category'   => 'configuration',
				'options'           => array(
					'1'         => esc_html( '1' ),
					'2'         => esc_html( '2' ),
					'3'         => esc_html( '3' ),
				),
				'default'           => '2',
				'show_if'          => array(
					'use_slider' => 'off',
				),
				'tab_slug'          => 'general',
				'toggle_slug'       => 'layout_toggle',
				'description'       => esc_html__( 'Here you can select the number of columns to display testimonials.', 'divi-testimonial-extended' ),
			),
			'use_masonry' => array(
				'label'            => esc_html__( 'Enable Masonry', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'          => array(
					'use_slider' => 'off',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'layout_toggle',
				'description'      => esc_html__( 'Enable Masonry for testimonials.', 'divi-testimonial-extended' ),
			),
			'show_pagination' => array(
				'label'            => esc_html__( 'Show Pagination', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'      => array(
					'use_slider' => 'off',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'pagination_setting',
				'description'      => esc_html__( 'Show Pagination or not.', 'divi-testimonial-extended' ),
			),
			'show_prev_next' => array(
				'label'            => esc_html__( 'Show Previous Next Links', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
				),
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
				),
				'default'          => 'off',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'pagination_setting',
				'description'      => esc_html__( 'Show Previous Next Links or not.', 'divi-testimonial-extended' ),
			),
			'next_text' => array(
				'label'            => esc_html__( 'Next Link Text', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'configuration',
				'default'		   => 'Next',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
					'show_prev_next'  => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'pagination_setting',
				'description'      => esc_html__( 'Here you can define Next Link text in numbered pagination.', 'divi-testimonial-extended' ),
			),
			'prev_text' => array(
				'label'            => esc_html__( 'Prev Link Text', 'divi-testimonial-extended' ),
				'type'             => 'text',
				'option_category'  => 'configuration',
				'default'		   => 'Prev',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
					'show_prev_next'  => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'pagination_setting',
				'description'      => esc_html__( 'Here you can define Previous Link text in numbered pagination.', 'divi-testimonial-extended' ),
			),
			'use_slider' => array(
				'label'            => esc_html__( 'Enable Slider', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'on',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'      => esc_html__( 'Enable Slider for testimonials.', 'divi-testimonial-extended' ),
			),
			'slide_effect' => array(
				'label'           => esc_html__( 'Slide Effect', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'slide'     => esc_html__( 'Slide', 'divi-testimonial-extended' ),
					'cube'      => esc_html__( 'Cube', 'divi-testimonial-extended' ),
					'coverflow' => esc_html__( 'Coverflow', 'divi-testimonial-extended' ),
					'flip'      => esc_html__( 'Flip', 'divi-testimonial-extended' ),
					'fade'      => esc_html__( 'Fade', 'divi-testimonial-extended' ),
				),
				'default'         => 'slide',
				'show_if'          => array(
					'use_slider' => 'on',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can choose the slide animation effect.', 'divi-testimonial-extended' ),
			),
			'testimonial_per_slide' => array(
				'label'           => esc_html__( 'Number of Testimonials Per View', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'1' => esc_html__( '1', 'divi-testimonial-extended' ),
					'2' => esc_html__( '2', 'divi-testimonial-extended' ),
					'3' => esc_html__( '3', 'divi-testimonial-extended' ),
					'4' => esc_html__( '4', 'divi-testimonial-extended' ),
					'5' => esc_html__( '5', 'divi-testimonial-extended' ),
				),
				'default'         => '1',
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array(
						'slide', 'coverflow',
					),
				),
				'mobile_options'  => true,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can choose the number of testimonials to display per slide.', 'divi-testimonial-extended' ),
			),
			'slides_per_group' => array(
				'label'           => esc_html__( 'Number of Slides Per Group', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'1'  => esc_html__( '1', 'divi-testimonial-extended' ),
					'2'  => esc_html__( '2', 'divi-testimonial-extended' ),
					'3'  => esc_html__( '3', 'divi-testimonial-extended' ),
					'4' => esc_html__( '4', 'divi-testimonial-extended' ),
					'5' => esc_html__( '5', 'divi-testimonial-extended' ),
				),
				'default'         => '1',
				'mobile_options'  => true,
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array( 'slide' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can choose the number of slides per group to slide by.', 'divi-testimonial-extended' ),
			),
			'space_between_slides' => array(
				'label'           => esc_html__( 'Space between Slides', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'layout',
				'range_settings'  => array(
					'min'  => '10',
					'max'  => '100',
					'step' => '1',
				),
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array( 'slide', 'coverflow' ),
				),
				'fixed_unit'	  => 'px',
				'default'         => '20px',
				'mobile_options'  => true,
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Move the slider or input the value to increse or decrease the space between slides.', 'divi-testimonial-extended' ),
			),
			'enable_coverflow_shadow' => array(
				'label'            => esc_html__( 'Enable Slide Shadow', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array(
						'coverflow',
					),
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'      => esc_html__( 'Enable Slide Shadow For Coverflow Effect.', 'divi-testimonial-extended' ),
			),
			'coverflow_shadow_color' => array(
				'label'        => esc_html__( 'Shadow Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'description'  => esc_html__( 'Here you can select color for the Shadow.' ),
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array(
						'coverflow',
					),
					'enable_coverflow_shadow' => array(
						'on',
					),
				),
				'default'      => '#ccc',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
			),
			'coverflow_rotate' => array(
				'label'           => esc_html__( 'Coverflow Rotate', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '360',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array(
						'coverflow',
					),
				),
				'default'         => '40',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'     => esc_html__( 'Coverflow Rotate Slide.', 'divi-testimonial-extended' ),
			),
			'coverflow_depth' => array(
				'label'           => esc_html__( 'Coverflow Depth', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'use_slider' => 'on',
					'slide_effect' => array(
						'coverflow',
					),
				),
				'default'         => '100',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'     => esc_html__( 'Coverflow Depth Slide.', 'divi-testimonial-extended' ),
			),
			'equal_testimonials_height' => array(
				'label'            => esc_html__( 'Equalize Testimonials Height', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'display_setting',
				'description'      => esc_html__( 'Choose whether or not equalize testimonial height.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'auto_height_slider' => array(
				'label'           => esc_html__( 'Auto Height Slider', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__( 'Off', 'divi-testimonial-extended' ),
					'on'  => esc_html__( 'On', 'divi-testimonial-extended' ),
				),
				'default'         => 'off',
				'show_if'          => array(
					'use_slider' => 'on',
					'equal_testimonials_height' => 'off',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can choose whether or not slider height should adjust according to each slide.', 'divi-testimonial-extended' ),
			),
			'transition_duration' => array(
				'label'           => esc_html__( 'Transition Duration', 'divi-testimonial-extended' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'default'         => '1000',
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can specify the duration of transition for each slide in miliseconds.', 'divi-testimonial-extended' ),
			),
			'slider_loop' => array(
				'label'           => esc_html__( 'Enable Loop', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'show_if_not'     => array(
					'slide_effect' => 'coverflow',
				),
				'default'         => 'off',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Here you can enable loop for the slides.', 'divi-testimonial-extended' ),
			),
			'autoplay' => array(
				'label'           => esc_html__( 'Autoplay', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'This controls the auto play the testimonial slider.', 'divi-testimonial-extended' ),
			),
			'autoplay_speed' => array(
				'label'           => esc_html__( 'Autoplay Delay', 'divi-testimonial-extended' ),
				'type'            => 'text',
				'option_category' => 'configuration',
				'default'         => '3000',
				'show_if'         => array(
					'use_slider' => 'on',
					'autoplay' => 'on',
				),
				'show_if_not'     => array(
					'autoplay' => 'off',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'This controls the time of the slide before the transition.', 'divi-testimonial-extended' ),
			),
			'pause_on_hover' => array(
				'label'           => esc_html__( 'Pause On Hover', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'show_if'         => array(
					'use_slider' => 'on',
					'autoplay' => 'on',
				),
				'show_if_not'     => array(
					'autoplay' => 'off',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'slider_settings',
				'description'     => esc_html__( 'Control for pausing slides on mouse hover.', 'divi-testimonial-extended' ),
			),
			'show_author_image' => array(
				'label'           => esc_html__( 'Show Author Image', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'display_setting',
				'description'     => esc_html__( 'Choose whether or not the author image should be visible.', 'divi-testimonial-extended' ),
			),
			'author_image_layout' => array(
				'label'           => esc_html__( 'Author Image Layout', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'rounded' => esc_html__( 'Rounded', 'divi-testimonial-extended' ),
					'square'  => esc_html__( 'Square', 'divi-testimonial-extended' ),
				),
				'default'         => 'rounded',
				'show_if'         => array(
					'show_author_image' => 'on',
				),
				'show_if_not'     => array(
					'show_author_image' => 'off',
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'display_setting',
				'description'     => esc_html__( 'Here you can choose the author image layout.', 'divi-testimonial-extended' ),
			),
			'use_gravatar' => array(
				'label'            => esc_html__( 'Use Gravatar', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'          => array(
					'show_author_image' => 'on',
				),
				'show_if_not'      => array(
					'show_author_image' => 'off',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'display_setting',
				'description'      => esc_html__( 'Use Gravatar if author image is not uploaded.', 'divi-testimonial-extended' ),
				'computed_affects' => array(
					'__testimonial_data',
				),
			),
			'show_author_designation' => array(
				'label'           => esc_html__( 'Show Designation', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'display_setting',
				'description'     => esc_html__( 'Choose whether or not the designation should be visible.', 'divi-testimonial-extended' ),
			),
			'show_author_company_name' => array(
				'label'           => esc_html__( 'Show Company Name', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'display_setting',
				'description'     => esc_html__( 'Choose whether or not the company name should be visible.', 'divi-testimonial-extended' ),
			),
			'layout1_top_background' => array(
				'label'           => esc_html__( 'Top', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'description'     => esc_html__( 'Select design element for the upper half.' ),
				'options'         => array(
					'select' => esc_html__( 'Select', 'divi-testimonial-extended' ),
					'color'  => esc_html__( 'Color', 'divi-testimonial-extended' ),
					'image'  => esc_html__( 'Image', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'testimonial_layout' => 'layout1',
				),
				'default'         => 'select',
				'tab_slug'        => 'advanced',
				'description'     => esc_html__( 'Select whether to use color or image as background for the top part.', 'divi-testimonial-extended' ),
				'toggle_slug'     => 'slide_setting_toggle',
			),
			'layout1_top_background_color' => array(
				'label'        => esc_html__( 'Top Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'description'  => esc_html__( 'Here you can select color for the top part.' ),
				'show_if'      => array(
					'testimonial_layout'     => 'layout1',
					'layout1_top_background' => 'color',
				),
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Bottom Background', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout1_top_background_image' => array(
				'label'              => esc_html__( 'Top Image', 'divi-testimonial-extended' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'divi-testimonial-extended' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'divi-testimonial-extended' ),
				'update_text'        => esc_attr__( 'Set As Image', 'divi-testimonial-extended' ),
				'show_if'            => array(
					'testimonial_layout'     => 'layout1',
					'layout1_top_background' => 'image',
				),
				'tab_slug'           => 'advanced',
				'toggle_slug'        => 'slide_setting_toggle',
				'description'        => esc_html__( 'Upload an image to display at the background on the top.', 'divi-testimonial-extended' ),
			),
			'layout1_bottom_background_color' => array(
				'label'        => esc_html__( 'Bottom Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'description'  => esc_html__( 'Here you can select color for the bottom part.' ),
				'show_if'      => array(
					'testimonial_layout' => 'layout1',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout2_background_color' => array(
				'label'        => esc_html__( 'Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout2',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify background color for layout.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'meta_separator_color' => array(
				'label'        => esc_html__( 'Meta Separator Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout2',
				),
				'default'      => '#dddddd',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify color for the meta separator.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout3_background_color' => array(
				'label'        => esc_html__( 'Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout3',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify background color the slider.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout4_background_color' => array(
				'label'        => esc_html__( 'Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout4',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify background color the slider.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout5_background_color' => array(
				'label'        => esc_html__( 'Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout5',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify background color the slider.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'layout6_background_color' => array(
				'label'        => esc_html__( 'Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'testimonial_layout' => 'layout6',
				),
				'default'      => '#ffffff',
				'tab_slug'     => 'advanced',
				'description'  => esc_html__( 'Here you can specify background color the slider.', 'divi-testimonial-extended' ),
				'toggle_slug'  => 'slide_setting_toggle',
			),
			'slide_custom_padding' => array(
				'label'           => esc_html__( 'Slide Padding', 'divi-testimonial-extended' ),
				'type'            => 'custom_padding',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'show_if_not'      => array(
					'testimonial_layout' => 'layout1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'slide_setting_toggle',
				'description'     => esc_html__( 'Here you can choose Overlay Padding', 'divi-testimonial-extended' ),
			),
			'show_arrow' => array(
				'label'            => esc_html__( 'Show Arrows', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'on',
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'      => esc_html__( 'Choose whether or not the previous & next arrows should be visible.', 'divi-testimonial-extended' ),
			),
			'show_arrow_on_hover' => array(
				'label'           => esc_html__( 'Show Arrows On Hover', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'use_slider' => 'on',
					'show_arrow' => 'on',
				),
				'default'         => 'off',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'     => esc_html__( 'Choose whether or not the previous and next arrows should be visible.', 'divi-testimonial-extended' ),
			),
			'select_arrow' => array(
				'label'           => esc_html__( 'Select Arrow', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'arrow_forward_ios'    => esc_html( 'arrow_forward_ios' ),
					'keyboard_arrow_right' => esc_html( 'keyboard_arrow_right' ),
					'arrow_forward'        => esc_html( 'arrow_forward' ),
					'arrow_right'          => esc_html( 'arrow_right' ),
				),
				'show_if'         => array(
					'use_slider' => 'on',
					'show_arrow' => 'on',
				),
				'show_if_not'     => array(
					'show_arrow' => 'off',
				),
				'default'         => 'arrow_forward_ios',
				'option_class'    => 'el_md_select_arrow',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'     => esc_html__( 'Here you can choose the arrow design.', 'divi-testimonial-extended' ),
			),
			'arrow_font_size' => array(
				'label'           => esc_html__( 'Arrow Font Size', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'layout',
				'range_settings'  => array(
					'min'  => '10',
					'max'  => '100',
					'step' => '1',
				),
				'show_if'         => array(
					'use_slider' => 'on',
					'show_arrow' => 'on',
				),
				'default'         => '18px',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'slider_control',
				'description'     => esc_html__( 'Here you can choose the arrow font size.', 'divi-testimonial-extended' ),
			),
			'arrow_color' => array(
				'label'        => esc_html__( 'Arrow Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'use_slider' => 'on',
					'show_arrow' => 'on',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'slider_control',
				'description'  => esc_html__( 'Here you can define color for the arrow', 'divi-testimonial-extended' ),
			),
			'show_control_dot' => array(
				'label'            => esc_html__( 'Show Pagination', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'on',
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'      => esc_html__( 'This setting will turn on and off the pagination of the slider.', 'divi-testimonial-extended' ),
			),
			'control_dot_style' => array(
				'label'           => esc_html__( 'Pagination Style', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'solid_dot'       => esc_html__( 'Solid Dot', 'divi-testimonial-extended' ),
					'transparent_dot' => esc_html__( 'Transparent Dot', 'divi-testimonial-extended' ),
					'streched_dot'    => esc_html__( 'Streched Dot', 'divi-testimonial-extended' ),
					'line'            => esc_html__( 'Line', 'divi-testimonial-extended' ),
					'rounded_line'    => esc_html__( 'Rounded Line', 'divi-testimonial-extended' ),
					'square_dot'      => esc_html__( 'Squared Dot', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'use_slider' => 'on',
					'show_control_dot' => 'on',
				),
				'default'         => 'solid_dot',
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'     => esc_html__( 'control dot style', 'divi-testimonial-extended' ),
			),
			'enable_dynamic_dots' => array(
				'label'            => esc_html__( 'Enable Dynamic Dots', 'divi-testimonial-extended' ),
				'type'             => 'yes_no_button',
				'option_category'  => 'configuration',
				'options'          => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'          => 'off',
				'show_if'          => array(
					'use_slider' => 'on',
					'show_control_dot' => 'on',
					'control_dot_style' => array(
						'solid_dot',
						'transparent_dot',
						'square_dot'
					),
				),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'slider_settings',
				'description'      => esc_html__( 'This setting will turn on and off the dynamic pagination of the slider.', 'divi-testimonial-extended' ),
			),
			'control_dot_active_color' => array(
				'label'        => esc_html__( 'Active Pagination Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'use_slider' => 'on',
					'show_control_dot' => 'on',
				),
				'default'      => '#000000',
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'slider_control',
				'description'  => esc_html__( 'Here you can define color for the active pagination item.', 'divi-testimonial-extended' ),
			),
			'control_dot_inactive_color' => array(
				'label'        => esc_html__( 'Inactive Pagination Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'use_slider' => 'on',
					'show_control_dot' => 'on',
				),
				'default'      => '#cccccc',
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'slider_control',
				'description'  => esc_html__( 'Here you can define color for the inactive pagination item.', 'divi-testimonial-extended' ),
			),
			'show_quote_icon' => array(
				'label'           => esc_html__( 'Show Quote', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_opening',
				'description'     => esc_html__( 'Choose whether or not the quote icon should be visible.', 'divi-testimonial-extended' ),
			),
			'select_opening_quote_icon' => array(
				'label'           => esc_html__( 'Select Quote Icon', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'divi_default' => esc_html( '{' ),
					'format_quote' => esc_html( 'format_quote' ),
				),
				'show_if'         => array(
					'show_quote_icon' => 'on',
				),
				'default'         => 'divi_default',
				'option_class'    => 'el_md_select_opening_quote',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_opening',
				'description'     => esc_html__( 'Here you can choose the opening quote icon.', 'divi-testimonial-extended' ),
			),
			'quote_icon_size' => array(
				'label'           => esc_html__( 'Quote Size', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '350',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'show_quote_icon' => 'on',
				),
				'default'         => '56px',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_opening',
				'description'     => esc_html__( 'Here you can choose size of the quote icon.', 'divi-testimonial-extended' ),
			),
			'quote_icon_color' => array(
				'label'        => esc_html__( 'Quote Icon Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'show_quote_icon' => 'on',
				),
				'default'      => 'rgba(0,0,0,0.2)',
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'quote_icon_settings',
				'sub_toggle'   => 'quote_icon_opening',
				'description'  => esc_html__( 'Here you can define color for the quote icon', 'divi-testimonial-extended' ),
			),
			'custom_position_quote_icon' => array(
				'label'           => esc_html__( 'Enable Custom Position For Quote', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'show_quote_icon' => 'on',
				),
				'default'         => 'off',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_opening',
				'description'     => esc_html__( 'Choose whether or not the quote icon should be visible.', 'divi-testimonial-extended' ),
			),
			'quote_icon_position_top' => array(
				'label'           => esc_html__( 'Quote Icon Position From Top', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '0',
					'max'  => '100',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'show_quote_icon'            => 'on',
					'custom_position_quote_icon' => 'on',
				),
				'default'         => '10%',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_opening',
				'description'     => esc_html__( 'Here you can choose the quote icon size from top.', 'divi-testimonial-extended' ),
			),
			'quote_icon_position' => array(
				'label'           => esc_html__( 'Quote Icon Position', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'quote_left'   => esc_html__( 'Left', 'divi-testimonial-extended' ),
					'quote_center' => esc_html__( 'Center', 'divi-testimonial-extended' ),
					'quote_right'  => esc_html__( 'Right', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'show_quote_icon'            => 'on',
					'custom_position_quote_icon' => 'on',
				),
				'default'         => 'quote_left',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'description'     => esc_html__( 'opening quote icon position', 'divi-testimonial-extended' ),
				'sub_toggle'      => 'quote_icon_opening',
			),
			'show_quote_icon_closing' => array(
				'label'           => esc_html__( 'Show Quote', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'off',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'Choose whether or not the quote icon should be visible.', 'divi-testimonial-extended' ),
			),
			'select_closing_quote_icon' => array(
				'label'           => esc_html__( 'Select Quote Icon', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'divi_default' => esc_html( '{' ),
					'format_quote' => esc_html( 'format_quote' ),
				),
				'show_if'         => array(
					'show_quote_icon_closing' => 'on',
				),
				'default'         => 'divi_default',
				'option_class'    => 'el_md_select_opening_quote',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'Here you can choose the closing quote icon.', 'divi-testimonial-extended' ),
			),
			'quote_icon_size_closing' => array(
				'label'           => esc_html__( 'Quote Size', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '350',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'show_quote_icon_closing' => 'on',
				),
				'default'         => '56px',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'Here you can choose size of the quote icon.', 'divi-testimonial-extended' ),
			),
			'quote_icon_color_closing' => array(
				'label'        => esc_html__( 'Quote Icon Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'show_quote_icon_closing' => 'on',
				),
				'default'      => 'rgba(0,0,0,0.2)',
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'quote_icon_settings',
				'sub_toggle'   => 'quote_icon_closing',
				'description'  => esc_html__( 'Here you can define color for the quote icon', 'divi-testimonial-extended' ),
			),
			'custom_position_quote_icon_closing' => array(
				'label'           => esc_html__( 'Enable Custom Position For Quote', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'show_quote_icon_closing' => 'on',
				),
				'default'         => 'off',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'Choose whether or not the quote icon should be visible.', 'divi-testimonial-extended' ),
			),
			'quote_icon_position_bottom_closing' => array(
				'label'           => esc_html__( 'Quote Icon Position From Bottom', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'range_settings'  => array(
					'min'  => '0',
					'max'  => '100',
					'step' => '1',
				),
				'mobile_options'  => true,
				'show_if'         => array(
					'show_quote_icon_closing'            => 'on',
					'custom_position_quote_icon_closing' => 'on',
				),
				'default'         => '10%',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'Here you can choose the quote icon size from top.', 'divi-testimonial-extended' ),
			),
			'quote_icon_position_closing' => array(
				'label'           => esc_html__( 'Quote Icon Position', 'divi-testimonial-extended' ),
				'type'            => 'select',
				'option_category' => 'layout',
				'options'         => array(
					'quote_left'   => esc_html__( 'Left', 'divi-testimonial-extended' ),
					'quote_center' => esc_html__( 'Center', 'divi-testimonial-extended' ),
					'quote_right'  => esc_html__( 'Right', 'divi-testimonial-extended' ),
				),
				'show_if'         => array(
					'show_quote_icon_closing'            => 'on',
					'custom_position_quote_icon_closing' => 'on',
				),
				'default'         => 'quote_right',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'quote_icon_settings',
				'sub_toggle'      => 'quote_icon_closing',
				'description'     => esc_html__( 'cloing quote icon position', 'divi-testimonial-extended' ),
			),
			'show_rating' => array(
				'label'           => esc_html__( 'Show Ratings', 'divi-testimonial-extended' ),
				'type'            => 'yes_no_button',
				'option_category' => 'configuration',
				'options'         => array(
					'on'  => esc_html__( 'Yes', 'divi-testimonial-extended' ),
					'off' => esc_html__( 'No', 'divi-testimonial-extended' ),
				),
				'default'         => 'on',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'rating_settings',
				'description'     => esc_html__( 'Choose whether or not the rating should be visible.', 'divi-testimonial-extended' ),
			),
			'star_font_size' => array(
				'label'           => esc_html__( 'Star Font Size', 'divi-testimonial-extended' ),
				'type'            => 'range',
				'option_category' => 'layout',
				'range_settings'  => array(
					'min'  => '10',
					'max'  => '100',
					'step' => '1',
				),
				'show_if'         => array(
					'show_rating' => 'on',
				),
				'mobile_options'  => true,
				'default'         => '24px',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'rating_settings',
				'description'     => esc_html__( 'Here you can choose the star font size.', 'divi-testimonial-extended' ),
			),
			'filled_star_color' => array(
				'label'        => esc_html__( 'Rated Star Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'show_rating' => 'on',
				),
				'show_if_not'  => array(
					'show_rating' => 'off',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'rating_settings',
				'description'  => esc_html__( 'Here you can define color for the rated star.', 'divi-testimonial-extended' ),
			),
			'empty_star_color' => array(
				'label'        => esc_html__( 'Unrated Star Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'show_if'      => array(
					'show_rating' => 'on',
				),
				'show_if_not'  => array(
					'show_rating' => 'off',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'rating_settings',
				'description'  => esc_html__( 'Here you can define color for the unrated star.', 'divi-testimonial-extended' ),
			),
			'pagination_link_background_color' => array(
				'label'        => esc_html__( 'Pagination Link Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'default'	   => 'transparent',
				'hover'		   => 'tabs',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'pagination_settings',
				'description'  => esc_html__( 'Here you can define a custom background color for the pagination link.', 'divi-testimonial-extended' ),
			),
			'pagination_link_color' => array(
				'label'        => esc_html__( 'Pagination Link Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'hover'		   => 'tabs',
				'default'	   => '#000',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'pagination_settings',
				'description'  => esc_html__( 'Here you can define a custom color for the pagination link.', 'divi-testimonial-extended' ),
			),
			'active_pagination_link_background_color' => array(
				'label'        => esc_html__( 'Active Pagination Link Background Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'default'	   => '#000',
				'hover'		   => 'tabs',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'pagination_settings',
				'description'  => esc_html__( 'Here you can define a custom background color for the active pagination link.', 'divi-testimonial-extended' ),
			),
			'active_pagination_link_color' => array(
				'label'        => esc_html__( 'Active Pagination Link Color', 'divi-testimonial-extended' ),
				'type'         => 'color-alpha',
				'custom_color' => true,
				'default'	   => '#fff',
				'hover'		   => 'tabs',
				'show_if'      => array(
					'use_slider' => 'off',
					'show_pagination' => 'on',
				),
				'tab_slug'     => 'advanced',
				'toggle_slug'  => 'pagination_settings',
				'description'  => esc_html__( 'Here you can define a custom color for the active pagination link.', 'divi-testimonial-extended' ),
			),
			'testimonial_desc_custom_padding' => array(
				'label'           => esc_html__( 'Description Padding', 'divi-testimonial-extended' ),
				'type'            => 'custom_padding',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'description'     => esc_html__( 'Here you can choose testimonial description padding', 'divi-testimonial-extended' ),
			),
			'testimonial_desc_custom_margin' => array(
				'label'           => esc_html__( 'Description Margin', 'divi-testimonial-extended' ),
				'type'            => 'custom_margin',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'description'     => esc_html__( 'Here you can choose testimonial description margin', 'divi-testimonial-extended' ),
			),
			'author_name_custom_padding' => array(
				'label'           => esc_html__( 'Author Name Padding', 'divi-testimonial-extended' ),
				'type'            => 'custom_padding',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'description'     => esc_html__( 'Here you can choose testimonial author padding', 'divi-testimonial-extended' ),
			),
			'slider_container_custom_padding' => array(
				'label'           => esc_html__( 'Slider Container Padding', 'divi-testimonial-extended' ),
				'type'            => 'custom_padding',
				'option_category' => 'layout',
				'mobile_options'  => true,
				'show_if'      => array(
					'use_slider' => 'on',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'description'     => esc_html__( 'Here you can choose testimonial slider container padding', 'divi-testimonial-extended' ),
			),
			'__testimonial_data' => array(
				'type'                => 'computed',
				'computed_callback'   => array( 'El_Testimonial_Module', 'get_testimonial_data' ),
				'computed_depends_on' => array(
					'testimonial_number',
					'include_categories',
					'exclude_post_ids',
					'testimonial_order_by',
					'testimonial_order',
					'testimonial_offset',
					'show_title',
					'enable_readmore',
					'content_length',
				),
			),
		);
	}

	/**
	 * This function return values to react for front end builder.
	 *
	 * @param array arguments to get testimonial data
	 * @return array
	 */
	public static function get_testimonial_data( $args = array(), $conditional_tags = array(), $current_page = array() ) {
		$defaults = array(
			'testimonial_number'   => 10,
			'include_categories'   => '',
			'exclude_post_ids'	   => '',
			'testimonial_order_by' => 'date',
			'testimonial_order'    => 'DESC',
			'testimonial_offset'   => 0,
			'show_title'           => 'off',
			'enable_readmore'      => 'off',
			'content_length'       => 0,
		);

		$is_user_logged_in = (bool) et_fb_conditional_tag( 'is_user_logged_in', $conditional_tags );

		$attrs = wp_parse_args( $args, $defaults );
		foreach ( $defaults as $key => $default ) {
			${$key} = esc_html( et_()->array_get( $args, $key, $default ) );
		}

		$testimonial_number = ( 0 === $testimonial_number ) ? -1 : (int) $testimonial_number;

		$testimonial_args = array(
			'post_type'      => 'testimonials',
			'posts_per_page' => intval( $testimonial_number ),
			'orderby'        => sanitize_text_field( $testimonial_order_by ),
			'order'          => sanitize_text_field( $testimonial_order ),
			'post_status'	 => 'publish',
		);
		if ( 'rating' === $testimonial_order_by ) {
			$args['orderby'] 	= 'meta_value_num';
			$args['meta_key'] 	= 'testimonial_meta_box-rating';
		}
		if ( $include_categories && '' !== $include_categories && 'undefined' !== $include_categories ) {
			$testimonial_args['tax_query'] = array( array(
				'taxonomy' => 'testimonial_category',
				'field'    => 'term_id',
				'terms'    => explode( ',', $include_categories ),
				'operator' => 'IN',
			) );
		}
		if ( $is_user_logged_in ) {
			$testimonial_args['post_status'] = array( 'publish', 'private' );
		}
		if ( '' !== $exclude_post_ids ) {
			$exclude_post_ids = array_map( 'trim', explode( ',', $exclude_post_ids ) );
			$testimonial_args['post__not_in'] = array_map( 'intval', $exclude_post_ids );
		}
		if ( 0 !== $testimonial_offset ) {
			$testimonial_args['offset'] = absint( $testimonial_offset );
		}

		$the_query = new WP_Query( $testimonial_args );
		if ( -1 === $testimonial_args['posts_per_page'] ) {
			$total_pages = 1;
		} elseif ( '' !== $testimonial_args['offset'] && ! empty( $testimonial_args['offset'] ) ) {
			$total_pages = intval( ceil( ( $the_query->found_posts - $testimonial_args['offset'] ) / $testimonial_args['posts_per_page'] ) );
		} else {
			$total_pages = intval( ceil( $the_query->found_posts / $testimonial_args['posts_per_page'] ) );
		}

		if ( $the_query->have_posts() ) {
			$result = array();
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				$testimonial_id = esc_attr( get_the_ID() );

				// Testimonial content.
				if ( 'on' === $enable_readmore ) {
					$post_content = wp_strip_all_tags( do_shortcode( get_the_content( null, false, $testimonial_id ) ) );
					$testimonial_content = $post_content;
					if ( 0 < $content_length && strlen( $post_content ) > $content_length ) {
						$testimonial_content = self::el_testimonial_trim_content( $testimonial_content, intval( $content_length ) );
					}
				} else {
					$testimonial_content = do_shortcode( get_the_content( null, false, $testimonial_id ) );
				}

				$testimonial_data                       = array();
				$testimonial_data['testimonialID']      = $testimonial_id;
				$testimonial_data['title']              = get_the_title();
				$testimonial_data['testimonialContent'] = $testimonial_content;
				$testimonial_data['testimonial_url']    = get_the_permalink();
				$testimonial_data['authorImage']        = get_the_post_thumbnail_url() ? esc_attr( get_the_post_thumbnail_url( $testimonial_id, 'thumbnail' ) ) : 'empty';
				$author_email                           = sanitize_email( get_post_meta( $testimonial_id, 'testimonial_meta_box-email', true ) );
				if ( $author_email ) {
					$testimonial_data['authorGravatar'] = esc_url_raw( get_avatar_url( $author_email ) );
				}
				$testimonial_data['rating']      = (int) esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-rating', true ) );
				$testimonial_data['author']      = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-name', true ) );
				$testimonial_data['designation'] = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-designation', true ) );
				$testimonial_data['companyName'] = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company', true ) );
				$testimonial_data['companyUrl']  = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company_url', true ) );
				$testimonial_data['mysteryMan']  = esc_attr( plugins_url( 'assets/mystery-person.jpg', dirname( dirname( __FILE__ ) ) ) );
				$testimonial_data['total_pages'] = intval( $total_pages );
				array_push( $result, $testimonial_data );
			}
			wp_reset_postdata();
		} else {
			$result = 'no-result';
		}

		return $result;
	}

	public function render( $attrs, $content, $render_slug ) {
		$testimonial_layout         = esc_attr( $this->props['testimonial_layout'] );
		$layout1_top_bg_type        = esc_attr( $this->props['layout1_top_background'] );
		$layout1_top_bg_color       = esc_attr( $this->props['layout1_top_background_color'] );
		$layout1_top_img            = esc_attr( $this->props['layout1_top_background_image'] );
		$layout1_bottom_bg_color    = esc_attr( $this->props['layout1_bottom_background_color'] );
		$layout2_background_color   = esc_attr( $this->props['layout2_background_color'] );
		$meta_separator_color       = esc_attr( $this->props['meta_separator_color'] );
		$layout3_background_color   = esc_attr( $this->props['layout3_background_color'] );
		$layout4_background_color   = esc_attr( $this->props['layout4_background_color'] );
		$layout5_background_color   = esc_attr( $this->props['layout5_background_color'] );
		$layout6_background_color   = esc_attr( $this->props['layout6_background_color'] );
		$number_of_testimonials     = esc_attr( $this->props['testimonial_number'] );
		$testimonial_order          = esc_attr( $this->props['testimonial_order'] );
		$testimonial_order_by       = esc_attr( $this->props['testimonial_order_by'] );
		$testimonial_offset		    = esc_attr( $this->props['testimonial_offset'] );
		$testimonial_category       = esc_attr( $this->props['include_categories'] );
		$exclude_post_ids 		    = esc_attr( $this->props['exclude_post_ids'] );
		$equalize_height            = esc_attr( $this->props['equal_testimonials_height'] );
		$show_quote_icon            = esc_attr( $this->props['show_quote_icon'] );
		$select_opening_quote_icon  = esc_attr( $this->props['select_opening_quote_icon'] );
		$custom_position_quote_icon = esc_attr( $this->props['custom_position_quote_icon'] );
		$quote_icon_position        = esc_attr( $this->props['quote_icon_position'] );
		$quote_icon_position_top    = esc_attr( $this->props['quote_icon_position_top'] );
		$quote_icon_color           = esc_attr( $this->props['quote_icon_color'] );
		$quote_icon_size            = esc_attr( $this->props['quote_icon_size'] );
		$show_quote_icon_closing    = esc_attr( $this->props['show_quote_icon_closing'] );
		$select_closing_quote_icon  = esc_attr( $this->props['select_closing_quote_icon'] );
		$quote_icon_color_closing   = esc_attr( $this->props['quote_icon_color_closing'] );
		$quote_icon_size_closing    = esc_attr( $this->props['quote_icon_size_closing'] );
		$show_rating                = esc_attr( $this->props['show_rating'] );
		$star_font_size             = esc_attr( $this->props['star_font_size'] );
		$rated_star_color           = esc_attr( $this->props['filled_star_color'] );
		$unrated_star_color         = esc_attr( $this->props['empty_star_color'] );
		$show_author                = esc_attr( $this->props['show_author_image'] );
		$author_image_layout        = esc_attr( $this->props['author_image_layout'] );
		$use_gravatar               = esc_attr( $this->props['use_gravatar'] );
		$show_designation           = esc_attr( $this->props['show_author_designation'] );
		$show_company_name          = esc_attr( $this->props['show_author_company_name'] );
		$show_arrow                 = esc_attr( $this->props['show_arrow'] );
		$show_arrow_on_hover        = esc_attr( $this->props['show_arrow_on_hover'] );
		$arrow_font_size            = esc_attr( $this->props['arrow_font_size'] );
		$select_arrow               = esc_attr( $this->props['select_arrow'] );
		$arrow_color                = esc_attr( $this->props['arrow_color'] );
		$show_control               = esc_attr( $this->props['show_control_dot'] );
		$control_dot_style          = esc_attr( $this->props['control_dot_style'] );
		$control_active_color       = esc_attr( $this->props['control_dot_active_color'] );
		$control_inactive_color     = esc_attr( $this->props['control_dot_inactive_color'] );
		$transition_duration        = (int) esc_attr( $this->props['transition_duration'] );
		$enable_coverflow_shadow    = esc_attr( $this->props['enable_coverflow_shadow'] );
		$coverflow_shadow_color 	= esc_attr( $this->props['coverflow_shadow_color'] );
		$use_slider					= esc_attr( $this->props['use_slider'] );
		$number_of_columns			= intval( $this->props['number_of_columns'] );
		$use_masonry				= esc_attr( $this->props['use_masonry'] );
		$show_pagination			= esc_attr( $this->props['show_pagination'] );

		$show_title                 = esc_attr( $this->props['show_title'] );
		$title_level                = et_pb_process_header_level( $this->props['title_level'], 'h2' );
		$enable_readmore            = esc_attr( $this->props['enable_readmore'] );
		$content_length             = esc_attr( $this->props['content_length'] );
		$readmore_text              = esc_attr( $this->props['readmore_text'] );
		$readmore_inline            = esc_attr( $this->props['readmore_inline'] );
		$readmore_trigger           = esc_attr( $this->props['readmore_trigger'] );

		$custom_readmore_button	    = esc_attr( $this->props['custom_readmore_button'] );
		$readmore_button_icon       = $this->props['readmore_button_icon'];

		$order_class                 = $this->get_module_order_class( $render_slug );
		$order_number                = esc_attr( preg_replace( '/[^0-9]/', '', esc_attr( $order_class ) ) );
		$testimonial_per_view_ipad   = 1;
		$testimonial_per_view_mobile = 1;
		$quote_icon                  = '';
		$quote_icon_closing          = '';

		if ( 'on' === $use_slider ) {
			if ( 'on' === $enable_coverflow_shadow ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .swiper-container-3d .swiper-slide-shadow-left',
					'declaration' => sprintf( 'background-image: linear-gradient(to left,%1$s,rgba(0,0,0,0));', esc_html( $coverflow_shadow_color ) ),
				) );
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .swiper-container-3d .swiper-slide-shadow-right',
					'declaration' => sprintf( 'background-image: linear-gradient(to right,%1$s,rgba(0,0,0,0));', esc_html( $coverflow_shadow_color ) ),
				) );
			} else {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .swiper-container-3d .swiper-slide-shadow-left, %%order_class%% .swiper-container-3d .swiper-slide-shadow-right',
					'declaration' => 'background-image: none;',
				) );
			}
			if ( 'on' === $show_control ) {
				if ( $control_inactive_color ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-pagination-bullet',
						'declaration' => sprintf( 'background: %1$s;', esc_html( $control_inactive_color ) ),
					) );
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .transparent_dot .swiper-pagination-bullet',
						'declaration' => sprintf( 'border-color: %1$s;', esc_html( $control_inactive_color ) ),
					) );
				}
				if ( $control_active_color ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-pagination-bullet.swiper-pagination-bullet-active',
						'declaration' => sprintf( 'background: %1$s;', esc_html( $control_active_color ) ),
					) );
				}
				if ( 'streched_dot' === $control_dot_style && $transition_duration ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .streched_dot .swiper-pagination-bullet',
						'declaration' => sprintf( 'transition: all %1$sms;', esc_html( $transition_duration ) ),
					) );
				}
			}
			if ( 'on' === $show_arrow ) {
				if ( $arrow_color ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-button-prev, %%order_class%% .swiper-button-next',
						'declaration' => sprintf( 'color: %1$s;', esc_html( $arrow_color ) ),
					) );
				}
				if ( $arrow_font_size ) {
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-button-prev::after, %%order_class%% .swiper-button-next::after',
						'declaration' => sprintf( 'font-size: %1$s;', esc_html( $arrow_font_size ) ),
					) );
				}

				if ( '' !== $select_arrow ) {
					$select_arrow_prev = '';
					$select_arrow_next = '';
					switch ( $select_arrow ) {
						case 'arrow_forward_ios':
							$select_arrow_prev = 'arrow_back_ios';
							$select_arrow_next = 'arrow_forward_ios';
						break;
						case 'keyboard_arrow_right':
							$select_arrow_prev = 'keyboard_arrow_left';
							$select_arrow_next = 'keyboard_arrow_right';
						break;
						case 'arrow_forward':
							$select_arrow_prev = 'arrow_back';
							$select_arrow_next = 'arrow_forward';
						break;
						case 'arrow_right':
							$select_arrow_prev = 'arrow_left';
							$select_arrow_next = 'arrow_right';
						break;
						default:
							$select_arrow_prev = 'arrow_back_ios';
							$select_arrow_next = 'arrow_forward_ios';
						break;
					}

					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-button-prev::after',
						'declaration' => sprintf( 'content: "%1$s" !important;', esc_html( $select_arrow_prev ) ),
					) );
					ET_Builder_Element::set_style( $render_slug, array(
						'selector'    => '%%order_class%% .swiper-button-next::after',
						'declaration' => sprintf( 'content: "%1$s" !important;', esc_html( $select_arrow_next ) ),
					) );
				}
			}
		}

		if ( 'layout1' === $testimonial_layout ) {
			if ( $layout1_top_bg_color && 'color' === $layout1_top_bg_type ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout1 .el-testimonial-desc',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout1_top_bg_color ) ),
				) );
			}
			if ( $layout1_top_img && 'image' === $layout1_top_bg_type ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout1 .el-testimonial-desc',
					'declaration' => sprintf( 'background-image: url(%1$s);', esc_html( $layout1_top_img ) ),
				) );
			}
			if ( $layout1_bottom_bg_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .el-testimonial-meta',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout1_bottom_bg_color ) ),
				) );
			}
		}
		if ( 'layout2' === $testimonial_layout ) {
			if ( $layout2_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout2 .el-single-testimonial-card',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout2_background_color ) ),
				) );
			}
			if ( $meta_separator_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout2 .el-testimonial-meta',
					'declaration' => sprintf( 'border-top-color: %1$s;', esc_html( $meta_separator_color ) ),
				) );
			}
		}
		if ( 'layout3' === $testimonial_layout ) {
			if ( $layout3_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout3 .el-single-testimonial-card',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout3_background_color ) ),
				) );
			}
		}
		if ( 'layout4' === $testimonial_layout ) {
			if ( $layout4_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout4 .el-single-testimonial-card .el-testimonial-content',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout4_background_color ) ),
				) );
			}
		}
		if ( 'layout5' === $testimonial_layout ) {
			if ( $layout5_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout5 .el-single-testimonial-card .el-testimonial-content',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout5_background_color ) ),
				) );
			}
		}
		if ( 'layout6' === $testimonial_layout ) {
			if ( $layout6_background_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .layout6 .el-single-testimonial-card .el-testimonial-content .el-testimonial-content-wrapper',
					'declaration' => sprintf( 'background-color: %1$s;', esc_html( $layout6_background_color ) ),
				) );
			}
		}

		$custom_position_quote_icon_closing = esc_attr( $this->props['custom_position_quote_icon_closing'] );
		$quote_icon_position_closing        = esc_attr( $this->props['quote_icon_position_closing'] );
		$quote_icon_position_bottom_closing = esc_attr( $this->props['quote_icon_position_bottom_closing'] );

		if ( 'on' === $show_quote_icon ) {
			$opening_icon_class 	   = ( 'divi_default' === $select_opening_quote_icon ) ? 'el_md_default_opening_icon' : 'el_md_material_opening_icon';
			$select_opening_quote_icon = ( 'divi_default' === $select_opening_quote_icon ) ? ET_BUILDER_PRODUCT_VERSION < '4.13.0' ? et_pb_process_font_icon( '%%90%%' ) : et_pb_process_font_icon( '&#x7b;||divi||400' ) : 'format_quote';
			if ( $quote_icon_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .el-quote-opening',
					'declaration' => sprintf( 'color: %1$s;', esc_html( $quote_icon_color ) ),
				) );
			}
	
			$quote_icon_size = et_pb_responsive_options()->get_property_values( $this->props, 'quote_icon_size' );
			if ( ! empty( array_filter( $quote_icon_size ) ) ) {
				et_pb_responsive_options()->generate_responsive_css( $quote_icon_size, '%%order_class%% .el-quote-opening', 'font-size', $render_slug, '', 'range' );
			}
			if ( 'on' === $custom_position_quote_icon && $quote_icon_position_top ) {
				$quote_icon_position_top = et_pb_responsive_options()->get_property_values( $this->props, 'quote_icon_position_top' );
				if ( ! empty( array_filter( $quote_icon_position_top ) ) ) {
					et_pb_responsive_options()->generate_responsive_css( $quote_icon_position_top, '%%order_class%% .el-quote-opening.quote-custom', 'top', $render_slug, '', 'range' );
				}
			}
			$quote_icon = '';
			if ( 'off' === $custom_position_quote_icon ) {
				$quote_icon = '<span class="el-quote-opening '.$opening_icon_class.'">'.$select_opening_quote_icon.'</span>';
			} elseif ( 'on' === $custom_position_quote_icon ) {
				$quote_icon = '<span class="el-quote-opening  '.$opening_icon_class.' quote-custom ' . $quote_icon_position . '">'.$select_opening_quote_icon.'</span>';
			}
		}

		if ( 'on' === $show_quote_icon_closing ) {
			$closing_icon_class 		= ( 'divi_default' === $select_closing_quote_icon ) ? 'el_md_default_closing_icon' : 'el_md_material_closing_icon';
			$select_closing_quote_icon 	= ( 'divi_default' === $select_closing_quote_icon ) ? '{' : 'format_quote';
			if ( $quote_icon_color_closing ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .el-quote-closing',
					'declaration' => sprintf( 'color: %1$s;', esc_html( $quote_icon_color_closing ) ),
				) );
			}

			$quote_icon_size_closing = et_pb_responsive_options()->get_property_values( $this->props, 'quote_icon_size_closing' );
			if ( ! empty( array_filter( $quote_icon_size_closing ) ) ) {
				et_pb_responsive_options()->generate_responsive_css( $quote_icon_size_closing, '%%order_class%% .el-quote-closing', 'font-size', $render_slug, '', 'range' );
			}

			if ( 'on' === $custom_position_quote_icon_closing && $quote_icon_position_bottom_closing ) {
				$quote_icon_position_bottom_closing = et_pb_responsive_options()->get_property_values( $this->props, 'quote_icon_position_bottom_closing' );
				if ( ! empty( array_filter( $quote_icon_position_bottom_closing ) ) ) {
					et_pb_responsive_options()->generate_responsive_css( $quote_icon_position_bottom_closing, '%%order_class%% .el-quote-closing', 'bottom', $render_slug, '', 'range' );
				}
			}
			$quote_icon_closing = '';
			if ( 'off' === $custom_position_quote_icon_closing ) {
				$quote_icon_closing = '<span class="el-quote-closing '.$closing_icon_class.'">'.$select_closing_quote_icon.'</span>';
			} elseif ( 'on' === $custom_position_quote_icon_closing ) {
				$quote_icon_closing = '<span class="el-quote-closing '.$closing_icon_class.' quote-custom ' . $quote_icon_position_closing . '">'.$select_closing_quote_icon.'</span>';
			}
		}

		if ( 'on' === $show_rating ) {
			if ( $rated_star_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .el-testimonial-rating .el-rated:after',
					'declaration' => sprintf( 'color: %1$s;', esc_html( $rated_star_color ) ),
				) );
			}
			if ( $unrated_star_color ) {
				ET_Builder_Element::set_style( $render_slug, array(
					'selector'    => '%%order_class%% .el-testimonial-rating .el-non-rated:after',
					'declaration' => sprintf( 'color: %1$s;', esc_html( $unrated_star_color ) ),
				) );
			}

			$star_font_size = et_pb_responsive_options()->get_property_values( $this->props, 'star_font_size' );
			if ( ! empty( array_filter( $star_font_size ) ) ) {
				et_pb_responsive_options()->generate_responsive_css( $star_font_size, '%%order_class%% .el-testimonial-rating .el-rated,
									%%order_class%% .el-testimonial-rating .el-non-rated', 'font-size', $render_slug, '', 'range' );
			}
		}

		if ( 'off' === $use_slider ) {
			self::set_style( $render_slug, array(
				'selector'    => '%%order_class%% .el-testimonial-layout',
				'declaration' => 'display: table; width: 100%;'
			) );
		}

		if ( 'on' === $show_pagination ) {
			$this->generate_styles( array(
				'base_attr_name' => 'pagination_link_background_color',
				'selector'       => '%%order_class%% .el_md_testimonial_pagination_wrapper li a',
				'hover_selector' => '%%order_class%% .el_md_testimonial_pagination_wrapper li a:hover',
				'css_property'   => 'background-color',
				'render_slug'    => $render_slug,
				'type'           => 'color',
			) );
			$this->generate_styles( array(
				'base_attr_name' => 'pagination_link_color',
				'selector'       => '%%order_class%% .el_md_testimonial_pagination_wrapper li a',
				'hover_selector' => '%%order_class%% .el_md_testimonial_pagination_wrapper li a:hover',
				'css_property'   => 'color',
				'render_slug'    => $render_slug,
				'type'           => 'color',
			) );
			$this->generate_styles( array(
				'base_attr_name' => 'active_pagination_link_background_color',
				'selector'       => '%%order_class%% .el_md_testimonial_pagination_wrapper li.active a',
				'hover_selector' => '%%order_class%% .el_md_testimonial_pagination_wrapper li.active a:hover',
				'css_property'   => 'background-color',
				'render_slug'    => $render_slug,
				'type'           => 'color',
			) );
			$this->generate_styles( array(
				'base_attr_name' => 'active_pagination_link_color',
				'selector'       => '%%order_class%% .el_md_testimonial_pagination_wrapper li.active a',
				'hover_selector' => '%%order_class%% .el_md_testimonial_pagination_wrapper li.active a:hover',
				'css_property'   => 'color',
				'render_slug'    => $render_slug,
				'type'           => 'color',
			) );
		}

		$number_of_testimonials = ( 0 === $number_of_testimonials ) ? -1 : (int) $number_of_testimonials;
		$args = array(
			'post_type'      => 'testimonials',
			'posts_per_page' => $number_of_testimonials,
			'post_status'    => 'publish',
			'orderby'        => 'date',
			'order'          => 'DESC',
		);

		if ( is_user_logged_in() ) {
			$args['post_status'] = array( 'publish', 'private' );
		}
		if ( $testimonial_category && '' !== $testimonial_category ) {
			$args['tax_query'] = array( array(
				'taxonomy' => 'testimonial_category',
				'field'    => 'term_id',
				'terms'    => explode( ',', esc_attr( $testimonial_category ) ),
				'operator' => 'IN',
			) );
		}
		if ( '' !== $testimonial_order_by ) {
			if ( 'rating' === $testimonial_order_by ) {
				$args['orderby'] 	= 'meta_value_num';
				$args['meta_key'] 	= 'testimonial_meta_box-rating';
			} else {
				$args['orderby'] = $testimonial_order_by;
			}
		}
		if ( '' !== $testimonial_order ) {
			$args['order'] = $testimonial_order;
		}
		if ( 0 !== $testimonial_offset ) {
			$args['offset'] = absint( $testimonial_offset );
		}
		if ( '' !== $exclude_post_ids ) {
			$exclude_post_ids = array_map( 'trim', explode( ',', $exclude_post_ids ) );
			$args['post__not_in'] = array_map( 'intval', $exclude_post_ids );
		}

		$the_query = new WP_Query( $args );
		if ( $the_query->have_posts() ) {
			if ( 'off' === $use_slider ) {
				$number_of_columns 	= intval( $number_of_columns );
				$column_class 		= " el-testimonial-cols-{$number_of_columns}";
				$equal_height 		= '';
				wp_enqueue_script( 'elicus-isotope-script' );
				wp_enqueue_script( 'elicus-images-loaded-script' );
				if ( 'on' === $show_pagination ) {
					wp_enqueue_script( 'elicus-twbs-pagination' );
					$data_props = array(
						'testimonial_layout',
						'use_masonry',
						'number_of_columns',
						'testimonial_number',
						'include_categories',
						'testimonial_order_by',
						'testimonial_order',
						'testimonial_offset',
						'exclude_post_ids',
						'show_author_image',
						'author_image_layout',
						'use_gravatar',
						'show_author_designation',
						'show_author_company_name',
						'show_quote_icon',
						'show_quote_icon_closing',
						'custom_position_quote_icon',
						'custom_position_quote_icon_closing',
						'quote_icon_position',
						'show_rating',
					);

					if ( 'on' === $this->props['show_prev_next'] ) {
						array_push( $data_props, 'show_prev_next', 'prev_text', 'next_text' );
					}
					if ( 'on' === $show_quote_icon ) {
						$opening_quote_icon = 'data-select_opening_quote_icon="'. $select_opening_quote_icon .'"';
					}
					if ( 'on' === $show_quote_icon_closing ) {
						$closing_quote_icon = 'data-select_closing_quote_icon="'. $select_closing_quote_icon .'"';
					}

					$data_atts = $this->props_to_html_data_attrs( $data_props );
					if ( -1 === $args['posts_per_page'] ) {
						$total_pages = 1;
					} elseif ( '' !== $args['offset'] && ! empty( $args['offset'] ) ) {
						$total_pages = intval( ceil( ( $the_query->found_posts - $args['offset'] ) / $args['posts_per_page'] ) );
					} else {
						$total_pages = intval( ceil( $the_query->found_posts / $args['posts_per_page'] ) );
					}

					$pagination = sprintf(
						'<div class="el_md_testimonial_pagination_wrapper" data-total_pages="%1$s" data-is_user_logged_in="%2$s" %3$s %4$s %5$s>
							<ul></ul>
						</div>',
						$total_pages,
						is_user_logged_in(),
						$data_atts,
						'on' === $show_quote_icon ? $opening_quote_icon : '',
						'on' === $show_quote_icon_closing ? $closing_quote_icon : ''
					);
				}
			} else {
				$column_class = '';
				$equal_height = ( 'on' === $equalize_height ) ? ' el-testimonial-equal-heights' : '';
				wp_enqueue_script( 'elicus-swiper-script' );
				wp_enqueue_style( 'elicus-swiper-style' );
			}

			$testimonials = '<div class="el-testimonial-layout ' . $testimonial_layout . $equal_height . $column_class . '">';
			if ( 'on' === $use_slider ) {
				$testimonials .= '<div class="swiper-container"><div class="swiper-wrapper">';
			}
			if ( 'off' === $use_slider && 'on' === $use_masonry && 1 !== $number_of_columns ) {
				$testimonials .= '<div class="el-testimonial-isotope-container">';
			}

			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$testimonial_id = esc_attr( get_the_ID() );

				// Get Star Rating.
				$rating = '';
				$rate = esc_attr( (int) get_post_meta( $testimonial_id, 'testimonial_meta_box-rating', true ) );
				if ( 'on' === $show_rating && 0 !== $rate ) {
					$rating  = '<div class="el-testimonial-rating">';
					$rating .= '<span itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">';
					$rating .= '<span class="rating-value" itemprop="ratingValue">' . $rate . '</span>';
					if ( $rate < 5 ) {
						for ( $i = 1; $i <= $rate; $i++ ) {
							$rating .= '<span class="el-rated"></span>';
						}
						for ( $i = 1; $i <= ( 5 - $rate ); $i++ ) {
							$rating .= '<span class="el-non-rated"></span>';
						}
					} else {
						for ( $i = 1; $i <= $rate; $i++ ) {
							$rating .= '<span class="el-rated"></span>';
						}
					}
					$rating .= '</span>';
					$rating .= '</div>';
				}

				// Get Author Image.
				$author_image = '';
				if ( 'on' === $show_author ) {
					// Author Image.
					$featured_image = has_post_thumbnail( $testimonial_id );
					$author_image   = '<div class="el-testimonial-portrait '. esc_attr( $author_image_layout ) . '">';
					if ( $featured_image ) {
						$author_image .= get_the_post_thumbnail( $testimonial_id, 'thumbnail' );
					} elseif ( 'on' === $use_gravatar ) {
						$author_email = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-email', true ) );
						if ( $author_email ) {
							$avatar_image_url = esc_attr( get_avatar_url( $author_email ) );
						}
						if ( false !== $avatar_image_url ) {
							$author_image .= '<img alt="gravatar" src="' . $avatar_image_url . '" />';
						} else {
							$author_image .= '<img alt="mystery person" src="' . plugins_url( 'assets/mystery-person.jpg', dirname( dirname( __FILE__ ) ) ) . '" class="el-mystery-person" />';
						}
					} else {
						$author_image .= '<img alt="mystery person" src="' . plugins_url( 'assets/mystery-person.jpg', dirname( dirname( __FILE__ ) ) ) . '" class="el-mystery-person" />';
					}
					$author_image .= '</div>';
				}

				// Get Author Name.
				$author_name = '';
				$name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-name', true ) );
				if ( '' !== $name ) {
					$author_name = '<div class="el-testimonial-name">' . $name . '</div>';
				}

				// Get Author Designation.
				$author_designation = '';
				if ( 'on' === $show_designation ) {
					$desgination = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-designation', true ) );
					if ( '' !== $desgination ) {
						$company_name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company', true ) );
						if ( 'on' === $show_company_name && '' !== $company_name && 'layout3' !== $testimonial_layout ) {
							$author_designation = '<span class="el-testimonial-designation">' . $desgination . ',</span>';
						} else {
							$author_designation = '<span class="el-testimonial-designation">' . $desgination . '</span>';
						}
					}
				}

				// Get Company Details.
				$company_detail = '';
				if ( 'on' === $show_company_name ) {
					$company_name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company', true ) );
					$company_url  = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company_url', true ) );
					if ( '' !== $company_url && '' !== $company_name ) {
						$company_detail = sprintf(
							'<span class="el-testimonial-company">
								<a href="%1$s" target="_blank" rel="nofollow">%2$s</a>
							</span>',
							esc_url( $company_url ),
							esc_html( $company_name )
						);
					} elseif ( '' !== $company_name ) {
						$company_detail = '<span class="el-testimonial-company">' . $company_name . '</span>';
					}
				}

				// Testimonial content.
				if ( 'on' === $enable_readmore ) {
					$post_content = wp_strip_all_tags( do_shortcode( get_the_content( null, false, $testimonial_id ) ) );
					$testimonial_content = $post_content;
					if ( 0 < $content_length && strlen( $post_content ) > $content_length ) {
						$testimonial_content = self::el_testimonial_trim_content( $testimonial_content, intval( $content_length ) );
					}
				} else {
					$testimonial_content = do_shortcode( get_the_content( null, false, $testimonial_id ) );
				}
			
				// Read more button.
				$readmore_button = '';
				if ( 'on' === $enable_readmore && 0 < $content_length && strlen( $post_content ) > $content_length ) {
					// Get trigger on button click.
					$readmore_classes = array( 'el-testimonial-readmore-btn' );
					$readmore_action  = get_the_permalink();
					if ( 'expand_content' === $readmore_trigger ) {
						$readmore_classes[] = 'el-action-show-content';
						$readmore_action    = '#show-content-' . base64_encode( $testimonial_id );
					}

					$readmore_button = $this->render_button( array(
						'button_text'      => ! empty( $readmore_text ) ? esc_html( $readmore_text ) : esc_html__( 'Read More', 'divi-testimonial-extended' ),
						'button_url'       => $readmore_action,
						'button_classname' => $readmore_classes,
						'has_wrapper'      => false,
						'url_new_window'   => 'off',
						'button_custom'    => $custom_readmore_button,
						'custom_icon'	   => $readmore_button_icon,
					) );

					// Add read less button.
					if ( 'expand_content' === $readmore_trigger && ! empty( $this->props['readless_text'] ) ) {
						$readmore_button .= sprintf(
							'<a href="#hide-content-%1$s" class="el-testimonial-readless-btn">%2$s</a>',
							base64_encode( $testimonial_id ),
							esc_html( $this->props['readless_text'] )
						);
					}

					// if not inline, wrap buttons.
					if ( 'off' === $readmore_inline ) {
						$readmore_button = sprintf( '<div class="et_pb_button_wrapper">%1$s</div>', $readmore_button );
					}
				}

				// Testimonial title.
				$title = '';
				if ( 'on' === $show_title ) {
					$title = sprintf( '<%1$s class="el-testimonial-title">%2$s</%1$s>', esc_attr( $title_level ), get_the_title() );
				}

				$page = 1;
				if ( 'off' === $use_slider && 'on' === $use_masonry && 1 !== $number_of_columns ) {
					$testimonials .= '<div class="el-testimonial-isotope-item">';
				}
				include plugin_dir_path( __FILE__ ) . 'layouts/' . $testimonial_layout . '.php';
				if ( 'off' === $use_slider && 'on' === $use_masonry && 1 !== $number_of_columns ) {
					$testimonials .= '</div>';
				}
			}
			wp_reset_postdata();

			if ( 'off' === $use_slider && 'on' === $use_masonry && 1 !== $number_of_columns ) {
				$testimonials .= '</div> <!-- el-testimonial-isotope-container -->';
			}

			if ( 'on' === $use_slider ) {
				$testimonials .= '</div></div>';
				if ( 'on' === $show_arrow && 'on' === $show_arrow_on_hover ) {
					$testimonials .= '<div class="swiper-button-next arrow_on_hover arrow-' . $order_number . '"></div><div class="swiper-button-prev arrow_on_hover arrow-' . $order_number . '"></div>';
				} elseif ( 'on' === $show_arrow && 'off' === $show_arrow_on_hover ) {
					$testimonials .= '<div class="swiper-button-next arrow-' . $order_number . '"></div><div class="swiper-button-prev arrow-' . $order_number . '"></div>';
				}
				if ( 'on' === $show_control ) {
					$testimonials .= '<div class="swiper-pagination ' . $control_dot_style . ' paged-' . $order_number . '"></div>';
				}

				$script = $this->el_render_slider_script( $order_class, $order_number, $this->props );

				$testimonials .=  $script;
			}
			$testimonials .= '</div>';

			if ( 'off' === $use_slider && 'on' === $show_pagination ) {
				$testimonials .= $pagination;
			}

			$output = $testimonials;
		} else {
			$output  = '<div class="entry">';
			$output  = '<h1>' . esc_html__( 'No Result Found!', 'divi-testimonial-extended' ) . '</h1>';
			$output .= '<p>' . esc_html__( 'The testimonial you requested could not be found. Try changing your module settings or add some new testimonials.', 'divi-testimonial-extended' ) . '</p>';
			$output .= '</div>';
		}

		$alignment = ( '' !== $this->get_text_orientation_classname() ) ? $this->get_text_orientation_classname() :
						( 'layout2' === $testimonial_layout ? ' et_pb_text_align_left' : ' et_pb_text_align_center' );

		$this->add_classname( array( $alignment ) );

		$this->process_advanced_css( $this, $render_slug, $this->margin_padding );
		$this->process_advanced_margin_padding_css( $this, $render_slug, $this->margin_padding );
		
		return $output;
	}

	public function process_advanced_css( $module, $function_name, $margin_padding ) {
		$utils           = ET_Core_Data_Utils::instance();
		$all_values      = $module->props;
		$advanced_fields = $module->advanced_fields;
		$order_class     = $this->get_module_order_class( 'el_md_testimonial_extended' );
		$padding_class   = '.' . $order_class . ' .el-testimonial-layout:not(.layout6) .el-testimonial-content, .'. $order_class .' .layout6 .el-testimonial-content-inner';
		if ( ! $module->has_vb_support() && ! $module->has_advanced_fields ) {
			return;
		}

		$label      = 'slide';
		$form_field = array(
			'label'          => 'Slide Padding',
			'margin_padding' => array(
				'css' => array(
					'main'      => $padding_class,
					'important' => 'all',
				),
			),
			'tab_slug'       => 'advanced',
			'toggle_slug'    => 'slide_setting_toggle',
		);
		$padding_key = "{$label}_custom_padding";
		if ( '' !== $utils->array_get( $all_values, $padding_key, '' ) ) {
			$settings                      = $utils->array_get( $form_field, 'margin_padding', array() );
			$form_field_margin_padding_css = $utils->array_get( $settings, 'css.main', '' );
			if ( empty( $form_field_margin_padding_css ) ) {
				$utils->array_set( $settings, 'css.main', $utils->array_get( $form_field, 'css.main', '' ) );
			}
			$margin_padding->update_styles( $module, $label, $settings, $function_name, '' );
		}
	}

	public function before_render() {
		$is_responsive = et_pb_responsive_options()->is_responsive_enabled( $this->props, 'testimonial_per_slide' );
		if ( ! $is_responsive ) {
			$testimonials_per_slide = $this->props['testimonial_per_slide'];
			if ( 'slide' === $this->props['slide_effect'] ) {
				$testimonials_per_slide_tablet = $testimonials_per_slide < 4 ? $testimonials_per_slide : 3;
				$testimonials_per_slide_mobile = 1;
			} elseif ( 'coverflow' === $this->props['slide_effect'] ) {
				$testimonials_per_slide_tablet = 3;
				$testimonials_per_slide_mobile = 1;
			}
			if ( isset( $testimonials_per_slide_tablet ) && '' !== $testimonials_per_slide_tablet ) {
				$this->props['testimonial_per_slide_tablet'] = $testimonials_per_slide_tablet;
			}
			if ( isset( $testimonials_per_slide_mobile ) && '' !== $testimonials_per_slide_mobile ) {
				$this->props['testimonial_per_slide_phone'] = $testimonials_per_slide_mobile;
			}
		}
	}

	public static function el_testimonial_trim_content( $content, $amount = 100, $end_width = '...', $add_remain_str = true ) {
		// decide if we need to append dots at the end of the string.
		if ( strlen( $content ) <= $amount ) {
			$echo_out = '';
		} else {
			$echo_out = $end_width;
			if ( $amount > intval( strlen( $echo_out ) ) ) {
				$amount = $amount - intval( strlen( $echo_out ) );
			}
		}

		// trim text to a certain number of characters, also remove spaces from the end of a string ( space counts as a character ).
		$truncate = rtrim( et_wp_trim_words( $content, $amount, '' ) );

		$final_output = $truncate;

		// Remove the last word to make sure we display all words correctly.
		if ( '' !== $echo_out ) {
			$new_words_array = (array) explode( ' ', $final_output );
			array_pop( $new_words_array );

			$truncate = implode( ' ', $new_words_array );

			// append dots to the end of the string.
			if ( '' !== $truncate ) {
				$final_output = sprintf( '%1$s<span class="el-more-dots">%2$s</span>', $truncate, $echo_out );
			}
		}

		// Add remain text.
		if ( true === $add_remain_str ) {
			// Replace the first occurs in string.
			$first_pos = strpos( $content, $truncate );
			if ( false !== $first_pos ) {
				$remain_str = substr( $content, $first_pos + strlen( $truncate ) );
				if ( ! empty( $remain_str ) ) {
					$final_output .= sprintf( '<span class="el-more-text">%1$s</span>', $remain_str );
				}
			}
		}

		return et_core_intentionally_unescaped( $final_output, 'html' );
	}

	/**
	 * This function dynamically creates script parameters according to the user settings
	 *
	 * @param string  $order_class order class of module.
	 * @param integer $order_number order number of module.
	 * @param array   $props module setting values.
	 * @return string
	 * */
	public function el_render_slider_script( $order_class, $order_number, $props ) {
		$slide_effect          	  = esc_attr( $props['slide_effect'] );
		$show_arrow            	  = esc_attr( $props['show_arrow'] );
		$show_control          	  = esc_attr( $props['show_control_dot'] );
		$loop                  	  = esc_attr( $props['slider_loop'] );
		$autoplay              	  = esc_attr( $props['autoplay'] );
		$autoplay_speed        	  = (int) esc_attr( $props['autoplay_speed'] );
		$transition_duration   	  = (int) esc_attr( $props['transition_duration'] );
		$pause_on_hover        	  = esc_attr( $props['pause_on_hover'] );
		$testimonials_per_slide   = esc_attr( $props['testimonial_per_slide'] );
		$auto_height_slider		  = 'on' === $props['auto_height_slider'] ? 'true' : 'false';
		$enable_coverflow_shadow  = ( 'on' === esc_attr( $props['enable_coverflow_shadow'] ) ) ? 'true' : 'false';
		$coverflow_rotate 	   	  = (int) esc_attr( $props['coverflow_rotate'] );
		$coverflow_depth 	   	  = (int) esc_attr( $props['coverflow_depth'] );
		$fade 					  = 'false';
		$testimonials_per_slide   = et_pb_responsive_options()->get_property_values( $this->props, 'testimonial_per_slide', '', true );
		$space_between_slides 	  = et_pb_responsive_options()->get_property_values( $this->props, 'space_between_slides', '', true );
		$slides_per_group 		  = et_pb_responsive_options()->get_property_values( $this->props, 'slides_per_group', '', true );
		$dynamic_bullets		  = 'on' === $this->props['enable_dynamic_dots'] && in_array( $this->props['control_dot_style'], array( 'solid_dot', 'transparent_dot', 'square_dot' ), true ) ? 'true' : 'false';
		$slidesPerGroup 		  = 1;
		$slidesPerGroupIpad		  = 1;
		$slidesPerGroupMobile	  = 1;
		$slidesPerGroupSkip		  = 0;
		$slidesPerGroupSkipIpad	  = 0;
		$slidesPerGroupSkipMobile = 0;

		if ( in_array( $slide_effect, array( 'slide', 'coverflow' ), true ) ) {
			$testimonials_per_view        		= $testimonials_per_slide['desktop'];
			$testimonials_per_view_ipad   		= '' !== $testimonials_per_slide['tablet'] ? $testimonials_per_slide['tablet'] : $this->props['testimonial_per_slide_tablet'];
			$testimonials_per_view_mobile 		= '' !== $testimonials_per_slide['phone'] ? $testimonials_per_slide['phone'] : $this->props['testimonial_per_slide_phone'];
			$testimonials_space_between   		= $space_between_slides['desktop'];
			$testimonials_space_between_ipad 	= '' !== $space_between_slides['tablet'] ? $space_between_slides['tablet'] : $testimonials_space_between;
			$testimonials_space_between_mobile  = '' !== $space_between_slides['phone'] ? $space_between_slides['phone'] : $testimonials_space_between_ipad;
			$slidesPerGroup 					= $slides_per_group['desktop'];
			$slidesPerGroupIpad					= '' !== $slides_per_group['tablet'] ? $slides_per_group['tablet'] : $slidesPerGroup;
			$slidesPerGroupMobile				= '' !== $slides_per_group['phone'] ? $slides_per_group['phone'] : $slidesPerGroupIpad;

			if ( $testimonials_per_view > $slidesPerGroup && 1 !== $slidesPerGroup ) {
				$slidesPerGroupSkip = $testimonials_per_view - $slidesPerGroup;
			}
			if ( $testimonials_per_view_ipad > $slidesPerGroupIpad && 1 !== $slidesPerGroupIpad ) {
				$slidesPerGroupSkipIpad = $testimonials_per_view_ipad - $slidesPerGroupIpad;
			}
			if ( $testimonials_per_view_mobile > $slidesPerGroupMobile && 1 !== $slidesPerGroupMobile ) {
				$slidesPerGroupSkipMobile = $testimonials_per_view_mobile - $slidesPerGroupMobile;
			}
		} else {
			$testimonials_per_view        		= 1;
			$testimonials_per_view_ipad   		= 1;
			$testimonials_per_view_mobile 		= 1;
			$testimonials_space_between   		= 0;
			$testimonials_space_between_ipad	= 0;
			$testimonials_space_between_mobile	= 0;
		}

		$autoplay_speed      = '' !== $autoplay_speed ? $autoplay_speed : 3000;
		$transition_duration = '' !== $transition_duration ? $transition_duration : 1000;
		$loop_param          = ( 'on' === $loop ) ? 'true' : 'false';

		$navigation = 'false';
		if ( 'on' === $show_arrow ) {
			$navigation = "{    
				nextEl: '." . esc_attr( $order_class ) . " .swiper-button-next.arrow-" . $order_number . "',
				prevEl: '." . esc_attr( $order_class ) . " .swiper-button-prev.arrow-" . $order_number . "',
			}";
		}

		$pagination = 'false';
		if ( 'on' === $show_control ) {
			$pagination = "{
				el: '." . esc_attr( $order_class ) . " .swiper-pagination.paged-" . $order_number . "',
				dynamicBullets: " . $dynamic_bullets . ",
				clickable: true,
			}";
		}

		$autoplay_param = 0;
		if ( 'on' === $autoplay ) {
			if ( 'on' === $pause_on_hover ) {
				$autoplay_param = '{
					delay:' . $autoplay_speed . ',
					disableOnInteraction: true,
				}';
			} else {
				$autoplay_param = '{
					delay:' . $autoplay_speed . ',
					disableOnInteraction: false,
				}';
			}
		}

		$slide_setting_cube = 'false';
		if ( 'cube' === $slide_effect ) {
			$slide_setting_cube = '{
				shadow: false,
				slideShadows: false,
			}';
		}

		$slide_setting_coverflow = 'false';
		if ( 'coverflow' === $slide_effect ) {
			$slide_setting_coverflow = '{
				rotate: '.$coverflow_rotate.',
				stretch: 0,
				depth: '.$coverflow_depth.',
				modifier: 1,
				slideShadows : '.$enable_coverflow_shadow.',
			}';
			$loop_param = 'true';
		}

		if ( 'fade' === $slide_effect ) {
			$fade = '{ crossFade: true }';
		}

		$script  = '<script>';
		$script .= 'jQuery(function($) {';
		$script .= 'var ' . esc_attr( $order_class ) . '_swiper = new Swiper(\'.' . esc_attr( $order_class ) . ' .swiper-container\', {
					slidesPerView: ' . $testimonials_per_view . ',
					autoplay: ' . $autoplay_param . ',
					spaceBetween: ' . intval( $testimonials_space_between ) . ',
					slidesPerGroup: ' . $slidesPerGroup . ',
					slidesPerGroupSkip: ' . $slidesPerGroupSkip . ',
					effect: "' . $slide_effect . '",
					cubeEffect: ' . $slide_setting_cube . ',
					coverflowEffect: ' . $slide_setting_coverflow . ',
					fadeEffect: ' . $fade . ',
					autoHeight: ' . $auto_height_slider . ',
					speed: ' . $transition_duration . ',
					loop: ' . $loop_param . ',
					pagination: ' . $pagination . ',
					navigation: ' . $navigation . ',
					grabCursor: \'true\',
					breakpoints: {
						1080: {
							slidesPerView: ' . $testimonials_per_view . ',
							spaceBetween: ' . intval( $testimonials_space_between ) . ',
							slidesPerGroup: ' . $slidesPerGroup . ',
							slidesPerGroupSkip: ' . $slidesPerGroupSkip . ',
						},
						767: {
							slidesPerView: ' . $testimonials_per_view_ipad . ',
							spaceBetween: ' . intval( $testimonials_space_between_ipad ) . ',
							slidesPerGroup: ' . $slidesPerGroupIpad . ',
							slidesPerGroupSkip: ' . $slidesPerGroupSkipIpad . ',
						},
						0: {
							slidesPerView: ' . $testimonials_per_view_mobile . ',
							spaceBetween: ' . intval( $testimonials_space_between_mobile ) . ',
							slidesPerGroup: ' . $slidesPerGroupMobile . ',
							slidesPerGroupSkip: ' . $slidesPerGroupSkipMobile . ',
						}
					},
			} );';

		if ( 'on' === $pause_on_hover && 'on' === $autoplay ) {
			$script .= 'jQuery(".' . esc_attr( $order_class ) . ' .swiper-container").on("mouseenter", function(e) {
					if ( typeof ' . esc_attr( $order_class ) . '_swiper.autoplay.stop === "function" ) {
						' . esc_attr( $order_class ) . '_swiper.autoplay.stop();
					}
				} );';
			$script .= 'jQuery(".' . esc_attr( $order_class ) . ' .swiper-container").on("mouseleave", function(e) {
					if ( typeof ' . esc_attr( $order_class ) . '_swiper.autoplay.start === "function" ) {
						' . esc_attr( $order_class ) . '_swiper.autoplay.start();
					}
				} );';
		}

		if ( 'on' !== $loop ) {
			$script .=  esc_attr( $order_class ) . '_swiper.on(\'reachEnd\', function(){
					' . esc_attr( $order_class ) . '_swiper.autoplay = false;
				} );';
		}

		$script .= '});</script>';

		return $script;
	}

	public function process_advanced_margin_padding_css( $module, $function_name, $margin_padding ) {
		$utils           = ET_Core_Data_Utils::instance();
		$all_values      = $module->props;
		$advanced_fields = $module->advanced_fields;

		// Disable if module doesn't set advanced_fields property and has no VB support.
		if ( ! $module->has_vb_support() && ! $module->has_advanced_fields ) {
			return;
		}

		$allowed_advanced_fields = array( 'testimonial_margin_padding' );
		foreach ( $allowed_advanced_fields as $advanced_field ) {
			if ( ! empty( $advanced_fields[ $advanced_field ] ) ) {
				foreach ( $advanced_fields[ $advanced_field ] as $label => $form_field ) {
					$margin_key  = "{$label}_custom_margin";
					$padding_key = "{$label}_custom_padding";
					if ( '' !== $utils->array_get( $all_values, $margin_key, '' ) || '' !== $utils->array_get( $all_values, $padding_key, '' ) ) {
						$settings = $utils->array_get( $form_field, 'margin_padding', array() );
						// Ensure main selector exists.
						$form_field_margin_padding_css = $utils->array_get( $settings, 'css.main', '' );
						if ( empty( $form_field_margin_padding_css ) ) {
							$utils->array_set( $settings, 'css.main', $utils->array_get( $form_field, 'css.main', '' ) );
						}

						$margin_padding->update_styles( $module, $label, $settings, $function_name, $advanced_field );
					}
				}
			}
		}
	}
}

new El_Testimonial_Module();
